<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ServicePermissionController;
use App\Http\Controllers\ServiceRoleController;
use App\Http\Controllers\UserServicePermissionController;



// Public routes (no auth required)
Route::post('register', [AuthController::class, 'register']);
Route::post('login', [AuthController::class, 'login']);
Route::get('validate-session', [AuthController::class, 'validateSession']); 


// Protected routes (require authentication and session tracking)
Route::middleware(['jwt.auth', 'session.limit', 'track.activity'])->group(function () {
    // Auth-related routes
    Route::post('logout', [AuthController::class, 'logout']);
    Route::post('refresh-token', [AuthController::class, 'refreshToken']);    
    // Service management routes
     Route::apiResource('services', ServiceController::class);
     Route::apiResource('service-permissions', ServicePermissionController::class);
     Route::apiResource('service-roles', ServiceRoleController::class);
     Route::post('user-permission', [AuthController::class, 'getUserServicePermissions']);
    
    // User permission routes
    Route::apiResource('user-service-permissions', UserServicePermissionController::class);

    Route::post('user-service-permission', [AuthController::class, 'getUserServicePermissions']);
    
    // User info route
    Route::apiResource('user', UserController::class, );
});



