<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Foundation\Configuration\Exceptions;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        api: __DIR__.'/../routes/api.php',  
        commands: __DIR__.'/../routes/console.php',
        health: '/up',       
    )

    ->withMiddleware(function (Middleware $middleware) {
        // API Middleware Group (simplified)
        $middleware->prepend(\Illuminate\Http\Middleware\HandleCors::class);
        $middleware->api([
         //   \Illuminate\Routing\Middleware\ThrottleRequests::class.':api',
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            \App\Http\Middleware\CheckSessionLimit::class,
            \App\Http\Middleware\TrackUserActivity::class,
        ]);
        // Minimal aliases for API
        $middleware->alias([
            'jwt.auth' => \App\Http\Middleware\JwtMiddleware::class,
            'auth' => \App\Http\Middleware\Authenticate::class,
            'can' => \Illuminate\Auth\Middleware\Authorize::class,
           // 'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
            'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
            // Custom middleware
            'session.limit' => \App\Http\Middleware\CheckSessionLimit::class,
            'track.activity' => \App\Http\Middleware\TrackUserActivity::class,
            'update.session' => \App\Http\Middleware\UpdateSessionActivity::class,
        ]);      
    })
    ->withExceptions(function (Exceptions $exceptions) {
        // Exception handling
    })->create();