<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'username',
        'email',
        'phone_number',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

  public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

 public function companyUserId()
{
    return $this->hasOne(CompanyUserId::class, 'user_id', 'id');
}

   public function servicePermissions()
{
    return $this->belongsToMany(ServicePermission::class, 'user_service_permissions', 'user_id', 'service_permission_id')
        ->withPivot('created_at', 'updated_at');
}


// app/Models/User.php
public function sessions()
{
    return $this->hasMany(UserSession::class);
}

public function activeSessions()
{
    return $this->sessions()->where('is_active', true);
}
}
