<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    //
    protected $table = "services";
    protected $fillable = [
        'name',
        'service_id',
        'descriptions',
        'uuid',        
    ];
    public function serviceRoles()
    {
        return $this->hasMany(ServiceRole::class, 'service_id');
    }
    public function servicePermissions()
    {
        return $this->hasMany(ServicePermission::class, 'service_id');
    }
   
}
