<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Agent extends Model
{
    protected $fillable = [
        'name',
        'msisdn',
        'password',
        'login_session',
        'last_login',
        'agent_type'
    ];


    public function getNameAttribute($value)
    {
        return strtoupper($value);
    }



    public function bookingHistories()
    {
        return $this->hasMany(BookingHistory::class);
    }


    public function calculateSalesAmount($departure_date, $comparison = '=')
    {
        // Query booking histories with a join on schedules to apply all necessary filters
        return $this->bookingHistories()
            ->whereIn('status', [3, 4])
            ->whereHas('schedule', function ($query) use ($departure_date, $comparison) {
                $query->where('trip_date', $comparison, $departure_date);
            })
            ->sum('fare');
    }

  



    public function company()
    {
        return $this->belongsTo(Company::class);
    }





   

  
}
