<?php

namespace App\Http\Middleware;

use Closure;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Exception;
use Illuminate\Http\Request;

class JwtMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        try {
            $token = $request->bearerToken();
            if (!$token) {
                return response()->json(['message' => 'Token not provided'], 401);
            }


            $key = (string) env('JWT_SECRET');

            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            // PROPER WAY 1: Use request attributes
            $request->attributes->add([
                'jwt_payload' => $decoded,
                'jwt_user_id' => $decoded->sub,
                'jwt_session_id' => $decoded->session_id ?? null
            ]);
            // PROPER WAY 2: Or use merge() for simpler cases
            $request->merge([
                'auth_user_id' => $decoded->sub
            ]);
            
            return $next($request);
            
        } catch (Exception $e) {
            return response()->json(['message' => 'Unauthorized: ' . $e->getMessage()], 401);
        }
    }
}