<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\UserSession;
use Symfony\Component\HttpFoundation\Response;

class CheckSessionLimit
{
    public function handle(Request $request, Closure $next): Response
    {
        if (!$request->user()) {
            return $next($request);
        }

        $deviceId = $request->header('X-Device-ID') ?: md5($request->userAgent());
        
        $activeSessions = UserSession::where('user_id', $request->user()->id)
            ->where('is_active', 1)
            ->get();

        $currentDeviceType = $activeSessions
            ->firstWhere('device_id', $deviceId)
            ?->device_type 
            ?? ($this->isMobile($request) ? 'mobile' : 'web');

        $count = $activeSessions
            ->where('device_type', $currentDeviceType)
            ->count();

        if ($count >= 2) {
            return response()->json([
                'message' => "Maximum 2 active {$currentDeviceType} sessions allowed",
                'current_sessions' => $count
            ], 403);
        }

        return $next($request);
    }

    protected function isMobile(Request $request): bool
    {
        return preg_match(
            '/Mobile|Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i', 
            $request->userAgent()
        );
    }
}