<?php
namespace App\Http\Controllers;

use App\Models\UserServicePermission;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

use App\Models\Service;
class UserServicePermissionController extends Controller

{
    public function index()
    {
       try {  
        $userservices=User::with(['servicePermissions.service'])->get();  
        $formatted= $userservices->map(function ($userservice) {
            return [
                'id' => $userservice->id,
                'phone_number' => $userservice->phone_number,
                'username' => $userservice->username,   
                //'permissions' => $userservice -      
                'permissions' => $userservice->servicePermissions->map(fn($perm) => [
                    'permission' => $perm->permission,
                    'service' => $perm->service->name
                ])
            ];
        });       
        
        return response()->json([
            'status' => 'success',
            'message' => 'User Services Permissions retrieved successfully',
            'data' => $formatted
        ], Response::HTTP_OK);

    } catch (\Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => 'Failed to retrieve services',
            'error' => $e->getMessage()
        ], Response::HTTP_INTERNAL_SERVER_ERROR);
    }
}
    public function store(Request $request)
    {

       $request->validate([
            'user_id' => 'required|integer|exists:users,id',  
            'service_permission_id' => 'required|integer|exists:service_permissions,id',
            
         ] , [
            'service_permission_id.required' => 'service_permission_id is required',
            'user_id.required' => 'user_ id is required',
        
        ]);        
       UserServicePermission::create($request->all());
       return response()->json([
            'status' => 'success',
            'message' => 'permission granted successfully',
            ], Response::HTTP_OK);

    }

    public function show($id)
    {
        return UserServicePermission::with(['user', 'service'])->findOrFail($id);
    }

    public function update(Request $request, $id)
    {
        $usp = UserServicePermission::findOrFail($id);
        $usp->update($request->all());
        return response()->json($usp);
    }

   public function destroy(Request $request)
{
    $request->validate([
        'user_id' => 'required|integer',
        'service_permission_id' => 'required|integer',
    ]);

    UserServicePermission::where('user_id', $request->user_id)
        ->where('service_permission_id', $request->service_permission_id)
        ->delete();

    return response()->json(['message' => 'Deleted']);
}



   // Return all services with their permissions, mark checked if user has
    public function getAllByService($userId)
    {
        $services = Service::with('servicePermissions')->get();
         
        $user = User::with('companyUserId')->findOrFail($userId);
        

        $userPermissions = UserServicePermission::where('user_id', $userId)
            ->pluck('service_permission_id')
            ->toArray();
             
        $data = $services->map(function ($service) use ($userPermissions) {
            return [
                'service_id' => $service->id,
                'service_name' => $service->name,
                'permissions' => $service->servicePermissions->map(function ($perm) use ($userPermissions) {
                    return [
                        'id' => $perm->id,
                        'label' => $perm->permission,
                        'dat' =>$userPermissions,
                        'checked' => in_array($perm->id, $userPermissions),
                    ];
                }),               
            ];
        });

        return response()->json(
            
            [
               'status'=> 'success',               
               'user_details'=> $user,
               'data' => $data
            ]);
    }
    
    // Toggle (add/remove) a permission for the user
    public function toggle(Request $request, $userId)
    {
        $request->validate([
            'permission_id' => 'required|integer',
            'checked' => 'required|boolean',
        ]);

        if ($request->checked) {
            UserServicePermission::firstOrCreate([
                'user_id' => $userId,
                'service_permission_id' => $request->permission_id,
            ]);
        } else {
            UserServicePermission::where('user_id', $userId)
                ->where('service_permission_id', $request->permission_id)
                ->delete();
        }

        return response()->json([
            'status' => 'success',
            'message' => 'Permission updated successfully']);
    }
}
